/*  Small demo of Browser-based controls
  To run successfully:
  1) Run this program
  2) Open up a browser window, shrink it down
  3) Go to: http://127.0.0.1:10002
  4) Press the "start" button in the browser
  5) Use the buttons, etc. to control the Processing program
*/

int xpos, ypos;
float radius = 150;
float angle = 0;
float angle_add = PI*5/180;   // 5 degrees

boolean Running = false;

void setup() {
   size(500,500);
   color(255);
   frameRate(10);
   background(150);
   xpos = int(width/2 + radius);
   ypos = height/2;
   brcShowMessages(true);
}

void draw() {
  brc();  // Check for incoming messages from the browser window
  
  String name = brcChanged();  // Name of any control that has sent a message
  
  if (name.equals("start")) Running = true;
  
  if (name.equals("stop")) Running = false;
  
  if (name.equals("clear"))
    background(150);
    
  if (!Running) return;
  
  // Draw another circle...
  angle += angle_add;
  xpos = width/2 + int(radius * cos(angle));
  ypos = height/2 + int(radius * sin(angle));
    
  circle(xpos, ypos, 25);
    
}
