/*  Small demo of Browser-based controls
  To run successfully:
  1) Run this program
  2) Open up a browser window, shrink it down
  3) Go to: http://127.0.0.1:10002
  4) Press the "start" button in the browser
  5) Use the buttons, etc. to control the Processing program
*/

int xpos, ypos;
float radius = 150;
float angle = 0;
float angle_add = PI*5/180;   // 5 degrees

boolean running = false;
boolean coloring = false;

void setup() {
   size(500,500);
   color(255);
   frameRate(10);
   background(150);
   xpos = int(width/2 + radius);
   ypos = height/2;
   brcShowMessages(true);
}

void draw() {
  brc();  // Check for incoming messages from the browser window
  
  String name = brcChanged();  // Name of any control that has sent a message
  
  if (name.equals("start")) running = true;
  
  if (name.equals("stop")) running = false;
  
  if (name.equals("clear"))
    background(150);
    
  if (name.equals("coloring")) {
    if (brcValue("coloring").equals("true"))
      coloring = true;
    else
      coloring = false;
  }
      
  if (name.equals("speed"))
    frameRate(int(brcValue("speed")));
    
  brcSetMonitor("x",mouseX);
  brcSetMonitor("y",mouseY);
    
  if (!running) return;
  
  // Draw another circle...
  angle += angle_add;
  xpos = width/2 + int(radius * cos(angle));
  ypos = height/2 + int(radius * sin(angle));
  
  if (coloring) {
    if (brcValue("colors").equals("RANDOM"))
      fill(random(255),random(255),random(255));
    else if (brcValue("colors").equals("RED"))
      fill(255,0,0);
    else
      fill(0,255,0);
  }
  else
    fill(255);
    
  if (brcValue("size").equals("S"))
    circle(xpos, ypos, 25);
  else if (brcValue("size").equals("M"))
    circle(xpos,ypos,50);
  else
    circle(xpos,ypos,100);
  
  fill(255);
  textSize(32);
  text(brcValue("title"),width/2 - 100, height/2);
}
