#! /usr/bin/python3

# BRC Factory.  Takes a BRC template and produces the webpage and the BRC utilities files

# Started 7/15/21
# Version 0.5: Added  brcShowMessages()
# Version 0.6: Adding the web-service
# Version 0.7: Adding Monitor
# Version 0.8: Folding webpage into BRC_Utilites.pde
# Version 0.85: Added Note
# Version 0.90: bug fixes: SendAll for Radio buttons.
# Version 0.91: bug: radio buttons displaying values not visual options
# Version 0.92: bug: fixed SendAll() problem
# Version 0.93: Added LABEL to BUTTON
# Version 1.01: (12/28/21): Fixed(?) "Content-Length" undercount by allowing Processing to compute it.

Version = "1.01"

Required = {'PDEFILE':"BRC_Utilities.pde",'LAYOUT':'HORIZONTAL','PORT':'10002'}
Types = ['RADIO','DROPDOWN','CHECKBOX','RANGE','TEXT','BUTTON','MONITOR','NOTE']
ControlSequence = []    # list of userids in sequence
Monitors = []   # list of monitor userids
pyControls = {}   # key = userid
BRCID = 0
Webpage = ''
Logfile = 'BRC_Factory.log'

import cgi, cgitb, sys, random, urllib, zipfile, time, os

#from web_template import *
#from brc_template import *

Server = False
OutputDir = ''
UserFilename = ''
TEXT_Header = 'Content-type: text/plain\n\n'

ErrorMsgHTML = '''Content-type: text/html

<html><body><p><p>
<center><table border="1" width="50%" ><tr><td><center><font color="red">
<!--<msg>-->
</font></center></td></tr></table></center>
<p><center><strong>Press the back arrow to return to the form</strong></center></p>
</body></html>'''


# ------------------------------------ main -------------------------------
def main(infile=None):
    global Server, UserFilename, OutputDir


    InitGlobals()
    
    msg,UserFilename,OutputDir = GetFilename(infile)
    if Server:
        cgitb.enable()
    if msg != '':
        ErrorMsg(msg)
        return
    if UserFilename == '':
        ErrorMsg('No filename for template file')
        return 

    try:
        f = open(UserFilename,'r')
    except:
        ErrorMsg('Cannot open file: '+UserFilename)
        return
    lines = f.read().strip().split('\n')
    f.close()

    msg = ReadTemplate(lines)
    if msg != '':
        ErrorMsg(msg)
        return


    msg = CreateWebpage(OutputDir)
    if msg != '':
        ErrorMsg(msg)
        return

    msg = WritePDE(OutputDir)
    if msg != '':
        ErrorMsg(msg)
        return

    if Server:
        OutputPDE = OutputDir+Required['PDEFILE']
        msg = WriteServerResults(OutputPDE)
        if msg != '':
            ErrorMsg(msg)
            return
        RemoveOldDataFiles()
        
    Log('')
    return

# -------------------------- InitGlobals ------------------
def InitGlobals():
    global ControlSequence, pyControls, BRCID, Server, Monitors, OutputDir, UserFilename
    ControlSequence = []
    pyControls = {}
    BRCID = 0
    Server = False
    OutputDir = ''
    UserFilename = ''
    Monitors = []
        
# ----------------------- GetFilename ---------------------
def GetFilename(infile):
    global Server, OutputDir, UserFilename
    
    if infile is not None:
        return '',infile,GetDir(infile)
    if len(sys.argv) > 1:
        return '',sys.argv[1],GetDir(sys.argv[1])
    # upload and store file
    form = cgi.FieldStorage()
    if 'uploadFile' in form:
        Server = True
        msg,UserFilename,OutputDir = GetUploadedFile(form)
        return msg,UserFilename,OutputDir
            
    return '','',''

# ------------------------- GetUploadedFile ------------------
def GetUploadedFile(form):
    f = form['uploadFile']
    if not f.filename:
        return 'No filename of uploaded file','','',''
    userFilename = urllib.parse.unquote(f.filename)
    if not f.file:
        return 'No file uploaded','',''
    contents = f.file.read()

    # Construct random subdirectory of "data/"
    # Count number of lines in the Logfile
    try:
        flog = open(Logfile,'r')
        s = flog.read()
        flog.close()
        n = str(s.count('\n'))
    except:
        n = '0'
    
    srandom = str(random.randrange(1000,10000))
    sdir = 'data/%s-%s' % (n,srandom)
    os.mkdir(sdir)
    sdir += '/'
    
    
    ourfilename = sdir+userFilename
    try:
        f2 = open(ourfilename,'wb')
        f2.write(contents)
        f2.close()
    except:
        return 'Server cannot write to '+ourfilename,'',''
    f2.close()
    return '',ourfilename,sdir
    
# --------------------- GetDir ------------------------------
def GetDir(filename):
    pos = filename.rfind('/')
    if pos > 0:
        return filename[:pos+1]
    else:
        pos = filename.rfind('\\')
        if pos > 0:
            return filename[:pos+1]
        return ''
        
# ------------------------- ErrorMsg --------------------------
def ErrorMsg(msg):
    if Server:
        print(ErrorMsgHTML.replace('<!--<msg>-->',msg))
        Log(msg)
    else:
        print("Error: ",msg)
    return

# --------------------------- WriteServerResults ---------------
def WriteServerResults(serverFilename):
    pdefile = Required['PDEFILE']
    html = BRC_Factory_results.replace('<!--<pdefilename>-->',pdefile)
    html = html.replace('<!--<serverFilename>-->',serverFilename)
    print(html)
    return ''

# -------------------------- RemoveOldDataFiles -----------------------
def RemoveOldDataFiles():
    old = 60*30    # half hour
    now = time.time()
    files = os.listdir('data/')
    for adir in files:
        adir = 'data/'+adir
        try:
            t = os.stat(adir).st_ctime
            if now - t > old and os.path.isdir(adir):
                # remove all files from the directory
                for afile in os.listdir(adir+'/'):
                    os.remove(adir+'/'+afile)
                # now remove the directory
                os.rmdir(adir)
        except:
            pass

# ----------------------- Log ---------------------------------------------
def Log(msg):
    try:
        f = open(Logfile,'a')
        ip = ''
        if 'REMOTE_ADDR' in os.environ:
            ip = os.environ['REMOTE_ADDR']
        tm = time.strftime('%Y-%m-%d %H-%M-%S')
        f.write(tm+' ip='+ip+' '+msg+'\n')
        f.close()
    except:
        pass
# ----------------------- ReadTemplate -------------------------
def ReadTemplate(lines):
    
    intype = False
    stype = ''
    sid = ''
    sid_lines = []
    
    for i in range(len(lines)):
        line = lines[i].strip()
        if '//' in line:    # struggling to remove // comments except for http://
            pos = line.find('//')
            while True:
                if pos == 0:
                    line = ''
                    break
                if line[pos-1] != ':':
                    line = line[:pos].strip()
                    break
                pos = line.find('//',pos+1)
                if pos < 0:
                    break
        if line == '':
            continue
        wordsl,wordsu = splitStrip(line)
        nw = len(wordsl)

        # Required settings
        if wordsu[0] in Required.keys():
            w = wordsu[0]
            if nw != 2:
                return 'Incorrect syntax in line "'+line+'"'
            if w == 'LAYOUT':
                w2 = wordsu[1]
                if w2 != 'VERTICAL' and w2 != 'HORIZONTAL':
                    return 'LAYOUT should be VERTICAL or HORIZONTAL'
            elif w == 'PORT':
                if not wordsl[1].isdigit():
                    return 'PORT number has be all digits'
            Required[w] = wordsl[1]
                
        # New control
        elif wordsu[0] == 'TYPE':
            if sid != '':
                msg = ProcessOne(sid,stype,sid_lines)
                if msg != '':
                    return msg
                sid = ''
                sid_lines = []
            if nw != 3:
                return 'TYPE line should have type-of-control and id.  Error in line: '+line
            stype = wordsu[1]
            if stype not in Types:
                return 'Unrecognized type in line: '+line
            sid = wordsl[2]
            
        # Continuing with same sid...
        elif wordsl[0] == sid:
            sid_lines.append(line)

        else:
            return 'Inrecognized line type in line: '+line
    if sid != '':
        msg = ProcessOne(sid, stype, sid_lines)
        if msg != '':
            return msg
    return ''

# -------------------------------------- splitStrip --------------------------------------
def splitStrip(s):
    wl = [x.strip() for x in s.split(',')]
    wu = [x.strip() for x in s.upper().split(',')]
    return wl,wu

# -------------------------------------- ProcessOne --------------------------------------
def ProcessOne(sid,stype,lines):
    dcontrol = {'type':stype}
    if stype == 'BUTTON':
        msg = ParseButton(dcontrol,lines,sid)
    elif stype == 'TEXT':
        msg = ParseText(dcontrol,lines)
    elif stype == 'CHECKBOX':
        msg = ParseCheckbox(dcontrol,lines)
    elif stype == 'RADIO':
        msg = ParseRadio(dcontrol,lines)
    elif stype == 'DROPDOWN':
        msg = ParseDropdown(dcontrol,lines)
    elif stype == 'RANGE':
        msg = ParseRange(dcontrol,lines,sid)
    elif stype == 'MONITOR':
        msg = ParseMonitor(dcontrol,lines,sid)
    elif stype == 'NOTE':
        msg = ParseNote(dcontrol,lines,sid)
    else:
        return ''
    if msg != '':
        return msg
    ControlSequence.append(sid)
    pyControls[sid] = dcontrol
    return ''

# -------------------------------------- ParseButton ------------------------------------------
def ParseButton(dc, lines, sid):
    global BRCID
    
    if len(lines) > 1:
        return 'BUTTON paragraph should have either one or two lines '
    if len(lines) == 0:
        dc['label'] = sid
    else:
        wl,wu = splitStrip(lines[0])
        if wu[1] != 'LABEL':
            return 'The second line of a BUTTON paragraph must be a LABEL line'
        dc['label'] = wl[2]
    dc['value'] = '0'
    dc['webid'] = 'brc_'+str(BRCID)
    BRCID += 1
    return ''

# -------------------------------------- ParseText -------------------------------------
def ParseText(dc, lines):
    global BRCID
    
    if len(lines) != 1:
        return 'TEXT paragraph should have only one line after TYPE, in line: '+lines[0]
    wl,wu = splitStrip(lines[0])
    if len(wu) != 3 or wu[1] != 'LABEL':
        return 'TEXT line should contain 3 items: ID,LABEL,label-text in line: '+lines[0]
    dc['label'] = wl[2]
    dc['value'] = ''
    dc['webid'] = 'brc_'+str(BRCID)
    BRCID += 1
    return ''

# ------------------------------------- ParseCheckbox ------------------------------------
def ParseCheckbox(dc, lines):
    global BRCID
    
    if len(lines) != 1:
        return 'CHECKBOX paragraph should have only one line after TYPE, in line: '+lines[0]
    wl,wu = splitStrip(lines[0])
    if (len(wu) != 3 and len(wu) != 4) or wu[1] != 'LABEL':
        return 'CHECKBOX line should contain <br/>3 items: ID,LABEL,label-text <br/>or 4 items: ID,LABEL,label-text,checked <br/>in line: '+lines[0]
    dc['label'] = wl[2]
    if len(wu) == 4:
        if wu[3] == 'CHECKED':
            dc['value'] = 'true'
        else:
            return 'CHECKBOX line should contain <br/>3 items: ID,LABEL,label-text <br/>or 4 items: ID,LABEL,label-text,checked <br/>in line: '+lines[0]
    else:
        dc['value'] = 'false'
    dc['webid'] = 'brc_'+str(BRCID)
    BRCID += 1

    return ''
    
# --------------------------------------- ParseRadio ------------------------------------------
def ParseRadio(dc,lines):
    options = []
    value = ''
    label = ''
    for line in lines:
        wl,wu = splitStrip(line)
        nw = len(wl)
        if nw < 3 or nw > 5:
            return 'Incorrect syntax for RADIO line in line: '+line
        if wu[1] not in ['LABEL','OPTION']:
            return 'Incorrect syntax for RADIO line in line: '+line
        if wu[1] == 'LABEL':
            label = wl[2]
        elif nw != 4 and nw != 5:
            return 'Incorrect syntax for RADIO line in line: '+line
        else:
            options.append([wl[2],wl[3]])
            if len(wl) == 5:
                if wu[4] != 'CHECKED':
                    return 'The last item in this line should be "CHECKED" in line: '+line
                value = wl[2]
            if value == '':
                value = wl[2]
    dc['label'] = label
    dc['value'] = value
    dc['options'] = options
    return ''

# -------------------------------------------- ParseDropDown -------------------------------------
def ParseDropdown(dc, lines):
    options = []
    value = ''
    label = ''
    
    for line in lines:
        wl,wu = splitStrip(line)
        nw = len(wl)
        if nw < 3 or nw > 5:
            return 'Incorrect syntax for DROPDOWN line in line: '+line
        if wu[1] not in ['LABEL','OPTION']:
            return 'Incorrect syntax for DROPDOWN line in line: '+line
        if wu[1] == 'LABEL':
            label = wl[2]
        elif nw != 4 and nw != 5:
            return 'Incorrect syntax for RADIO line in line: '+line
        else:
            options.append([wl[2],wl[3]])
            if len(wl) == 5:
                if wu[4] != 'SELECTED':
                    return 'The last item in this line should be "SELECTED" in line: '+line
                value = wl[2]
            if value == '':
                value = wl[2]
    dc['label'] = label
    dc['value'] = value
    dc['options'] = options
    return ''
            
# --------------------------------------------- ParseRange ------------------------------------
def ParseRange(dc, lines, sid):
    imin = 0
    imax = 10
    step = 1
    value = 5
    label = ''
    
    for line in lines:
        wl,wu = splitStrip(line)
        nw = len(wl)
        if nw != 3:
            return 'Incorrect syntax for RANGE line in line: '+line
        if wu[1] not in ['LABEL','MIN','MAX','STEP','VALUE']:
            return 'Incorrect syntax for DROPDOWN line in line: '+line
        if wu[1] == 'LABEL':
            label = wl[2]
        else:
            try:
                n = int(wl[2])
            except:
                return 'The third item must be en integer in line: '+line
            if wl[1] == 'MIN':
                imin = n
            elif wl[1] == 'MAX':
                imax = n
            elif wl[1] == 'STEP':
                step = n
            elif wl[1] == 'VALUE':
                value = n
            else:
                return 'Unrecognized RANGE option in line: '+line
    if not imin <= value <= imax:
        return 'VALUE must be between MIN and MAX in RANGE: '+sid
    if  (value-imin)%step != 0:
        return 'VALUE must be a integer nummber of STEPs above MIN in in RANGE: '+sid
    dc['label'] = label
    dc['min'] = str(imin)
    dc['max'] = str(imax)
    dc['step'] = str(step)
    dc['value'] = str(value)
    return ''

# ---------------------------------- ParseMonitor ---------------------------
def ParseMonitor(dc, lines, sid):
    global BRCID
    
    label = ''
    for line in lines:
        wl,wu = splitStrip(line)
        nw = len(wl)
        if nw != 3 or wu[1] != 'LABEL':
            return 'This MONITOR line should contain LABEL: '+line
        if wu[1] == 'LABEL':
            label = wl[2]
    dc['label'] = label
    dc['value'] = 'N/A'
    dc['webid'] = 'brc_'+str(BRCID)
    BRCID += 1
    Monitors.append(sid)

    return ''

# -------------------------------------- ParseNote -------------------------------------
def ParseNote(dc, lines, sid):
    shtml = ''
    if len(lines) == 0:
        return 'NOTE paragraph should have one or more LABEL lines'
    dc['label'] = sid
    for line in lines:
        wl,wu = splitStrip(line)
        if len(wu) < 3 or wu[1] != 'LABEL':
            return 'NOTE lines should have "LABEL" as the second word'
        pos = line.find(',')
        pos = line.find(',',pos+1)
        shtml += line[pos+1:].replace('"','\"')+'<br/>'
    shtml = shtml[:-5]
    dc['note'] = shtml
    dc['webid'] = 'brc_'+str(BRCID)
    return ''
    
# ------------------------------------------- CreateWebpage -------------------------------------
def CreateWebpage(sdir):
    global Webpage

    # Create Port and jsControls list
    outControls = []
    html = WebTemplate

    # Port:
    sport = 'const Port = '+Required['PORT']+';'
    html = html.replace('<!--<port>-->',sport)
    
    # Controls list
    hasMonitor = False
    nid = 0
    for i in range(len(ControlSequence)):
        userid = ControlSequence[i]
        ctrl = pyControls[userid]
        if ctrl['type'] == 'MONITOR':
            hasMonitor = True
        one = [ctrl['type']]
        nid += 1
        sid = 'brc_'+str(nid)
        if ctrl['type'] == 'RANGE':
            one.append(sid)
            one.append(userid)
            nid += 1
            one.append('brc_'+str(nid))
            outControls.append(one)
        else:
            one.append(sid)
            one.append(userid)
            outControls.append(one)
            
            
    # String version of outControls
    sout = 'const Controls=['
    for outC in outControls:
        el = '['
        for word in outC:
            el += '"'+word+'",'
        el = el[:-1]+'],\n'
        sout += el
    sout = sout[:-2]+'];'

    html = html.replace('<!--<controls>-->',sout)

    # hasMonitor
    if hasMonitor:
        html = html.replace('<!--<hasMonitor>-->','Monitor = true;')
    else:
        html = html.replace('<!--<hasMonitor>-->','Monitor = false;')
        

    if Required['LAYOUT'] == 'VERTICAL':
        htmlControls = SendAll+'\n<br/>\n'
    else:
        htmlControls = SendAll+'\n'+'<table><tr>'
    
    # Now for the controls themselves
    for outC in outControls:
        stype = outC[0]
        sid = outC[1]
        userid = outC[2]
        if stype == 'BUTTON':
            shtml = ButtonHtml.replace('<!--<id>-->',sid)
            shtml = ButtonHtml.replace('<!--<userid>-->',userid)
            shtml = shtml.replace('<!--<label>-->',pyControls[userid]['label'])
            htmlControls += td(shtml)
        elif stype == 'TEXT':
            shtml = TextHtml.replace('<!--<id>-->',sid)
            shtml = shtml.replace('<!--<userid>-->',userid)
            shtml = shtml.replace('<!--<label>-->',pyControls[userid]['label'])
            htmlControls += td(shtml)
        elif stype == 'CHECKBOX':
            shtml = CheckboxHtml.replace('<!--<id>-->',sid)
            shtml = shtml.replace('<!--<userid>-->',userid)
            shtml = shtml.replace('<!--<label>-->',pyControls[userid]['label'])
            checked = ''
            if pyControls[userid]['value'] == 'true':
                checked = 'checked="checked"'
            shtml = shtml.replace('<!--<checked>-->',checked)
            htmlControls += td(shtml)
        elif stype == 'DROPDOWN':
            shtml = DropHtmlStart.replace('<!--<label>-->',pyControls[userid]['label'])
            shtml2 = DropHtmlSelect.replace('<!--<id>-->',sid)
            shtml2 = shtml2.replace('<!--<userid>-->',userid)
            shtml += shtml2
            selected = pyControls[userid]['value']
            for sopt in pyControls[userid]['options']:
                shtml3 = DropHtmlOption.replace('<!--<optvalue>-->',sopt[0])
                shtml3 = shtml3.replace('<!--<optname>-->',sopt[1])
                selected = ''
                if pyControls[userid]['value'] == sopt[0]:
                    selected = 'selected="selected"'
                shtml3 = shtml3.replace('<!--<selected>-->',selected)
                shtml += shtml3
            shtml += DropHtmlEnd
            htmlControls += td(shtml)
        elif stype == 'RADIO':
            shtml = RadioHtmlStart.replace('<!--<label>-->',pyControls[userid]['label'])
            for sopt in pyControls[userid]['options']:
                shtml4 = RadioHtmlOption.replace('<!--<id>-->',sid)
                shtml4 = shtml4.replace('<!--<value>-->',sopt[0])
                shtml4 = shtml4.replace('<!--<optnamevalue>-->',userid+'='+sopt[0])
                shtml4 = shtml4.replace('<!--<optvalue>-->',sopt[1])
                checked = ''
                if pyControls[userid]['value'] == sopt[0]:
                    checked = 'checked="checked"'
                shtml4 = shtml4.replace('<!--<checked>-->',checked)
                shtml += shtml4
            shtml += RadioHtmlEnd
            htmlControls += td(shtml)
        elif stype == 'RANGE':
            shtml = RangeHtml.replace('<!--<label>-->',pyControls[userid]['label'])
            shtml = shtml.replace('<!--<id>-->',sid)
            shtml = shtml.replace('<!--<userid>-->',userid)
            shtml = shtml.replace('<!--<min>-->',pyControls[userid]['min'])
            shtml = shtml.replace('<!--<max>-->',pyControls[userid]['max'])
            shtml = shtml.replace('<!--<step>-->',pyControls[userid]['step'])
            shtml = shtml.replace('<!--<value>-->',pyControls[userid]['value'])
            sid1 = sid[:4]+str(int(sid[4:])+1)
            shtml = shtml.replace('<!--<idplus1>-->',sid1)
            htmlControls += td(shtml)
        elif stype == 'MONITOR':
            shtml = MonitorHtml.replace('<!--<id>-->',sid)
            shtml = shtml.replace('<!--<label>-->',pyControls[userid]['label'])
            htmlControls += td(shtml)
        elif stype == 'NOTE':
            shtml = NoteHtml.replace('<!--<id>-->',sid)
            shtml = shtml.replace('<!--<note>-->',pyControls[userid]['note'])
            htmlControls += td(shtml)
                                  
            
    if Required['LAYOUT'] == 'HORIZONTAL':
        htmlControls += '</tr></table>\n'
    html = html.replace('<!--<HTML_Controls>-->',htmlControls)
    
    Webpage = html
    
    return ''

# --------------------------------------- td ---------------------------
def td(shtml):
    if Required['LAYOUT'] == 'VERTICAL':
        return shtml
    else:
        return '<td>'+shtml+'</td>'
# ------------------------------------------ WritePDE ------------------------------------
def WritePDE(sdir):

    filename=sdir+Required['PDEFILE']
    try:
        f = open(filename,'w')
    except:
        return 'Cannot write to file: '+filename

    pde = BRCTemplate

    pde = pde.replace('<!--<port>-->',Required['PORT'])
    pde = pde.replace('<!--<brc_filename>-->',Required['PDEFILE'])
    pde = pde.replace('<!--<version>-->',Version)

    sout = ''
    ids = '{'
    values = '{'
    for userid in ControlSequence:
        if pyControls[userid]['type'] == 'MONITOR' or pyControls[userid]['type'] == 'NOTE':
            continue
        value = pyControls[userid]['value']
        ids += '"'+userid+'",'
        values += '"'+value+'",'
    
    if ids == '{':  # If no controls except NOTEs or MONITORS...
        sout += 'String[] BRC_ids = new String[] {}\n;'
        sout += 'String[] BRC_values = new String[] {};\n'
    else:
        sout += 'String[] BRC_ids = new String[] '+ids[:-1]+'};\n'
        sout += 'String[] BRC_values = new String[] '+values[:-1]+'};\n'
    pde = pde.replace('<!--<name_value_lines>-->',sout)

    # Monitors
    if len(Monitors) == 0:
        sout = 'String[] BRC_Monitors = new String[] {};\n'
        sout += 'String[] BRC_MonitorValues = new String[] {};\n'
    else:
        sout = ''
        ids = '{'
        for userid in Monitors:
            ids += '"'+userid+'",'
        sout = 'String[] BRC_Monitors = new String[] '+ids[:-1]+'};\n'
        sout += 'String[] BRC_MonitorValues = new String[] {'
        for i in range(len(Monitors)):
            if i > 0:
                sout += ','
            sout += '"N/A"'
        sout += '};\n';
    pde = pde.replace('<!--<monitors>-->',sout);

    # Write the webpage to the pde
    html = Webpage
    header = "HTTP/1.1 200 OK\nContent-Length: %d\nContent-Type: text/html\n\n" % len(html)
    html = "String BRC_WebBody = \n"+Multiline(html)   
    pde = pde.replace('<!--<webpage>-->',html)
    ##
    pde = pde.replace('<!--<webbodysize>-->',str(len(html)))
    ##
    
    f.write(pde)
    f.close()
    if not Server:
        print(filename)
    return ''

# ------------------------------Multiline -------------------------
def Multiline(s,NLEnd = True):
    if NLEnd and s[-1] != '\n':
        s += '\n'
    sout = ''
    line = '"'
    for c in s:
        if c == '\\':
            line += '\\'
        elif c == '"':
            line += '\\"'
        elif c == '\n':
            line += '\\n"\n+ '
            sout += line
            line = '"'
        else:
            line += c
    sout = sout[:-3]+';\n'
    return sout
            

    
#=========================================================================
# ============================ Processing Code ===========================
#=========================================================================

BRCTemplate='''import processing.net.*;

Server BRCServer;

int BRC_port = <!--<port>-->;
int BRC_WebBodySize = <!--<webbodysize>-->;

<!--<name_value_lines>-->
<!--<monitors>-->

ArrayList BRC_changed = new ArrayList();
boolean BRC_ShowMessages = false;
boolean BRC_Initialized = false;

void brcInit() {
  BRCServer = new Server(this,BRC_port);
  println("BRCFactory version <!--<version>-->");
  println("0. Create a small browser window.");
  println("1. Go to the url:  127.0.0.1:<!--<port>-->");
}

void brc() {
  if (!BRC_Initialized) {
    brcInit();
    BRC_Initialized = true;
  }
  brcServerRequest();
}

void brcServerRequest() {
    Client thisClient = BRCServer.available();
    if (thisClient != null) {
      if (thisClient.available() > 0) {
        String request = thisClient.readString();
        if (request.indexOf("favicon") > 0) {  // do not respond to request for favicon
          return;
        }
        if (request.indexOf("BRC::") == -1) { // request for html page
          //println(request);
          //String html = String.join("\\n",loadStrings(BRC_Controls));
          //html = html.substring(html.indexOf("<")); // remove first non_ASCII char
          //String sendit = brcServerResponse(html);
          //thisClient.write(sendit);
          //println(sendit);

          brcSendWebpage(thisClient);
          
        }
        else {   // incoming change of control variable
          int pos = request.indexOf("BRC::")+5;
          int pos2 = request.indexOf("::",pos);
          if (pos2 < 0) {
            thisClient.write(brcServerResponse("Bad request"));
            println("Bad request",request);
          }
          else {
            String payload = request.substring(pos,pos2).trim();
            payload = brcDecode(payload);
            String response = brcParseRequest(payload);
            thisClient.write(brcServerResponse(response));
            //println("payload",payload);
          }
        }
        
      }
    }
}

String brcServerResponse(String s) {
  return (String.format("HTTP/1.1 200 OK\\nContent-Length: %d\\nContent-Type: text/html\\n\\n%s",s.length(),s));
}  

String brcParseRequest(String payload) {
    boolean found = false;
    int i;
    
  // if "MONITORS"
  if (payload.equals("MONITORS"))
      return brcMonitorsResponse();
      
  // otherwise should be name=value   
  int pos = payload.indexOf("=");
  if (pos < 0) {return "Bad request, no =";}
  String id = new String(payload.substring(0,pos));
  String value = new String(payload.substring(pos+1));
  if (BRC_ShowMessages)
      println(id+"="+value);
  for (i = 0; i < BRC_ids.length; ++i) {
    if (id.equals(BRC_ids[i])){
      BRC_values[i] = value;
      BRC_changed.add(id);
      found = true;
      break;
    }
  }
  if (!found)
      return "ID not found: |"+payload+"|";
  return brcMonitorsResponse();
}

String brcMonitorsResponse() {
  String mResponse = "**";
  if (BRC_Monitors.length == 0)
      return "OK";
  for (int i = 0; i < BRC_Monitors.length; ++i) {
      mResponse += BRC_Monitors[i]+"="+BRC_MonitorValues[i];
      if (i != BRC_Monitors.length - 1)
         mResponse += "][";
  }
  return mResponse;
}

String brcChanged() {
  if (BRC_changed.size() == 0) {return "";}
  return BRC_changed.remove(0).toString();
}

String brcValue(String id) {
  for (int i = 0; i < BRC_ids.length; ++i) {
    if (id.equals(BRC_ids[i])) {return BRC_values[i];}
  }
  return "";
}

void brcSetMonitor(String monitorName, String monitorValue) {
  boolean found = false;
  for (int i = 0; i < BRC_Monitors.length; ++i)
    if (BRC_Monitors[i].equals(monitorName)) {
      BRC_MonitorValues[i] = monitorValue;
      found = true;
      break;
    }
  if (!found)
    println("Monitor name not found: "+monitorName);
}

void brcSetMonitor(String monitorName, int monitorValue) {
    brcSetMonitor(monitorName, str(monitorValue));
}

void brcSetMonitor(String monitorName, float monitorValue, int digitsPrecision) {
    String prec = "%."+str(digitsPrecision)+"f";
    String val = String.format(prec,monitorValue);
    brcSetMonitor(monitorName,val);
}

String brcDecode(String s) {
   int i, n1, n2;
   String out = "";
   char c;
   
     i = 0;
     while (i < s.length()) {
       c = s.charAt(i);
       if (c != '%' || i > (s.length()-3))
         out = out + c;
       else {
         n1 = brcHexVal((char) s.charAt(i+1));
         n2 = brcHexVal((char) s.charAt(i+2));
         if (n1 == -1 || n2 == -1)
           out = out + c;
         else {
           out = out + (char) (16*n1+n2);
           i += 2;
         }
       }
       //println(out+" "+i);
       ++i;
     }
   return out;
}

int brcHexVal(char c) {
  String hex = "0123456789ABCDEFabcdef";
  int i;
  for (i = 0; i < hex.length(); ++i) {
    if (c == hex.charAt(i)) {
      if (i <= 15)
        return i;
      else
        return i-6;
    }
  }
  return -1;
}

void brcShowMessages(boolean which) {
    BRC_ShowMessages = which;
}

// =============================== Webpage========================
<!--<webpage>-->
// =============================== End webpage ===================
void brcSendWebpage(Client client) {
    String head1 = "HTTP/1.1 200 OK\\nContent-Length: ";
    String head2 = "\\nContent-Type: text/html\\n\\n";
    String WebPage = head1+str(BRC_WebBody.length())+head2+BRC_WebBody;
    client.write(WebPage);
}

'''


# ========================================================================
# ============================ User's HTML/JScript code ==================
# ========================================================================

# Templates...

WebTemplate='''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
<title>BRC_Controls</title>

<style type="text/css">
.auto-style1 {
    border-color:red;
    border-width:1px;
    border-style:solid;
}
.monitor {
    border-color:blue;
    border-width:1px;
    border-style:solid;
}
</style>

<script>
//----------------------- Sending --------------------------------------
function Send(url,results_id) {
  var xhttp = new XMLHttpRequest();
  xhttp.onreadystatechange = function() {
    //alert(url);
    if (this.readyState == 4 && this.status == 200) {
      if (this.responseText.slice(0,2) != "**")
         document.getElementById(results_id).innerHTML = this.responseText;
      else {
         var result = UpdateMonitors(this.responseText.slice(2));
         document.getElementById(results_id).innerHTML = result;
      }
    }
  };
  xhttp.open("GET", url, true);
  xhttp.send(null);
}

function SendNameValue(name_value) {
    var url = "127.0.0.1:" + Port + "/BRC::" + name_value + "::";
    Send(url,'results');
}

// ---------------------------- Monitors ----------------------------
var MonitorTicker = null;

function StartMonitors() {
    if (Monitor) {
        MonitorTicker = setInterval(MonitorRequest,250);   // every 1/2 second
    }
}

function MonitorRequest() {
    SendNameValue("MONITORS");
}
        
function UpdateMonitors(incoming) {
    var pairs = incoming.split("][");
    var i, j, pair, found;
    for (i = 0; i < pairs.length; ++i) {
        found = false;
        pair = pairs[i].split("=");
        for (j = 0; j < Controls.length; ++j) {
            if (Controls[j][2] == pair[0]) { 
                document.getElementById(Controls[j][1]).innerHTML = "&nbsp;"+pair[1]+"&nbsp;";
                found = true;
                break;
            }
        }
        if (!found)
            return "Monitor not found: "+pair[0]
    }
    return "OK"
}

// ---------------------------------------------- Sendall and RangesInit ------------------------------

<!--<port>-->

// needed by Sendall() and RangesInit

/*
Typical controls:
const Controls=[["RADIO","brc_1","shade"],["DROPDOWN","brc_4","color"],["CHECKBOX","brc_5","grayscale"],
                ["RANGE","brc_6","size","brc_7"],["TEXT","brc_8","title"]];

*/

<!--<controls>-->

<!--<hasMonitor>-->

function Sendall() {
    var i, opt;
    
    for (i = 0; i < Controls.length; ++i) {
        if (Controls[i][0] == "RADIO") {
            var rads = document.getElementsByName(Controls[i][1]);
            for (opt = 0; opt < rads.length; ++opt) {
                if (rads[opt].checked)
                    SendNameValue(Controls[i][2]+"="+rads[opt].value);
            }
        }
        else if (Controls[i][0] == "DROPDOWN" || Controls[i][0] == "TEXT") {
            SendNameValue(Controls[i][2]+"="+document.getElementById(Controls[i][1]).value);
        }
        else if (Controls[i][0] == "CHECKBOX") {
            if (document.getElementById(Controls[i][1]).checked)
                SendNameValue(Controls[i][2]+"=true");
            else
                SendNameValue(Controls[i][2]+"=false");
        }
        else if (Controls[i][0] == "RANGE") {
            ShowRange(Controls[i][1],Controls[i][3],Controls[i][2]);
        }
    }
}



// ------------------------------------ Individual senders ---------------------------------
function SendRadio(name_value) {
    //alert(name_value);
    SendNameValue(name_value);
}

function SendCheckbox(id,brc_name) {
    if (document.getElementById(id).checked)
        SendNameValue(brc_name+'=true');
    else
        SendNameValue(brc_name+'=false');
}

// ---------------------------------------- Utility functions -------------------------------

function ShowRange(range_id,output_id,brc_name) {
    document.getElementById(output_id).innerHTML = document.getElementById(range_id).value;
    SendNameValue(brc_name+"="+document.getElementById(range_id).value);
}



</script>

</head>

<body onLoad="StartMonitors();">
<form name="brc">

<!--<HTML_Controls>-->

</form>
</body>
</html>
'''

SendAll='''<table cellpadding="3"><tr><td>
<table cellspacing="0" ><tr><td>BRC Web Controls: &nbsp;&nbsp; </td>
<td class="auto-style1"><label id="results">OK</label></td></tr></table></td>
<td><input type="button" name="sendall" id="sendall" value="Send all" onclick="Sendall();"/></td></tr></table>
'''

RadioHtmlStart='''<table cellpadding="3"><tr><td class="auto-style1"><!--<label>-->:&nbsp;&nbsp;&nbsp;\n'''
RadioHtmlOption='''<input type="radio" name="<!--<id>-->" value="<!--<value>-->" onclick="SendNameValue('<!--<optnamevalue>-->');"  <!--<checked>--> /> <!--<optvalue>-->&nbsp;&nbsp;&nbsp;\n'''
RadioHtmlEnd='''</td></tr></table>\n\n'''

DropHtmlStart='''<table ><tr><td class="auto-style1"><!--<label>-->:&nbsp;&nbsp;&nbsp;\n'''
DropHtmlSelect='''<select name="<!--<id>-->" id="<!--<id>-->" onchange="SendNameValue('<!--<userid>-->='+document.brc.<!--<id>-->.value);">\n'''
DropHtmlOption='''<option <!--<selected>--> value="<!--<optvalue>-->"><!--<optname>--></option>\n'''
DropHtmlEnd='''</select></td></tr></table>\n\n'''

RangeHtml='''<table ><tr><td class="auto-style1"><!--<min>-->  
    <input type="range" id="<!--<id>-->" name="<!--<id>-->" min="<!--<min>-->" max="<!--<max>-->" value="<!--<value>-->" step="<!--<step>-->"
    oninput="ShowRange('<!--<id>-->','<!--<idplus1>-->','<!--<userid>-->');" />  <!--<max>--><br/>
    <!--<label>-->: <label id="<!--<idplus1>-->"></label>
    </td></tr></table>\n\n'''

CheckboxHtml='''<table ><tr><td class="auto-style1">
<!--<label>-->:  <input name="<!--<id>-->" type="checkbox" <!--<checked>--> id="<!--<id>-->" onclick="SendCheckbox('<!--<id>-->','<!--<userid>-->');"/> 
</td></tr></table>\n\n'''

TextHtml='''<table ><tr><td class="auto-style1">
<!--<label>-->: <input type="text" name="<!--<id>-->" id="<!--<id>-->" onchange="SendNameValue('<!--<userid>-->='+document.getElementById('<!--<id>-->').value);" /> 
</td></tr></table>\n\n'''


ButtonHtml='''<input type="button" name="<!--<id>-->" id="<!--<id>-->" value="<!--<label>-->" onClick="SendNameValue('<!--<userid>-->='+Math.floor(Math.random()*1000000));" />
&nbsp;&nbsp;&nbsp;\n\n '''

MonitorHtml='''<table><tr><td class="auto-style1"><!--<label>--> <label id="<!--<id>-->" class="monitor">N/A</label>
</td></tr></table>\n\n'''

NoteHtml='''<table><tr><td class="auto-style1"><label id="<!--<id>-->"><!--<note>--></label></td></tr></table>\n\n'''

# ========================================================================
# ================================ BRC_Factory Web code ==================
# ========================================================================

BRC_Factory_results='''Content-type: text/html

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta content="en-us" http-equiv="Content-Language" />
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
<title>BRC_Factory</title>
<style type="text/css">
.auto-style1 {
    text-align: center;
}
.auto-style2 {
    border: 1px solid #000080;
}
.auto-style3 {
    font-family: Verdana, Geneva, Tahoma, sans-serif;
}
</style>
</head>
<body >
<h3 class="auto-style1">BRC_Factory (results)</h3>
<p class="auto-style1"><span class="auto-style3"><a href="BRC_Factory_upload.html">Back</a></span><br class="auto-style3"/>
        </p>
<table align="center" class="auto-style2" style="width: 60%">
    <tr>
        <td class="auto-style1">
        <br class="auto-style3"/>
        <span class="auto-style3">Below
        is the link to your Processing file: "<!--<pdefilename>-->"</span><br class="auto-style3" />
&nbsp;<span class="auto-style3">Download this file into the same 
        directory as your Processing sketch.</span><br class="auto-style3" />
        <br class="auto-style3" />
        <span class="auto-style3">The best way to do this is ...</span><br class="auto-style3" />
        <span class="auto-style3">a) on Windows: click with your right-hand 
        mouse button and choose "Save link as..." from the menu</span><br class="auto-style3" />
        <span class="auto-style3">or</span><br class="auto-style3" />
        <span class="auto-style3">b) on a Mac: hold down the Ctrl key and click 
        on the link with your mouse and then choose "Save link as..." from the 
        menu<br />
        <br />
        ...and make sure your browser does NOT change the name of the file while 
        downloading.<br />
        <br />
        <a href="<!--<serverFilename>-->"><!--<pdefilename>--></a>
        </span><br class="auto-style3" />
        </td>
    </tr>
</table>
</body>
</html>
'''

# ================================ End ===================================

if __name__ == '__main__':
    main()
    
